#encoding: utf-8

from os.path import join
import win32print
from pprint import pprint

class Imprimir:
	def __init__(self):
		pass

	@classmethod
	def localizarImpressorasCompativeis(cls):
		# na duvida deixo a impressora default como None
		printer_name = None
		# buscando a impressora ARGOX
		impressoras = win32print.EnumPrinters(win32print.PRINTER_ENUM_LOCAL)
		for impressora in impressoras:
			pprint(impressora)
			if impressora[1].find("Argox") != -1 or impressora[1].find("Datamax") != -1 or impressora[1].find("ZT230") != -1:
				printer_name = impressora[1].split(",")[0]
				break

		if printer_name == None:
			print "Nenhuma impressora ArgoX foi encontrada. Processo cancelado."
			return None
		else:
			return printer_name.replace("'", "\'").replace('"', "")

	def __carregar_modelo(self, modelo, **params):
		arq = open(join('etiquetas', modelo), "r")
		str = arq.read()
		str = str.format(**params)
		str = str.replace("\r", "").replace("\n", "\r\n")
		return str

	def __ler_imagem(self, nome):
		imagem = open(join('imagens', nome), "r").read()
		return imagem

	def __imprimir(self, dados):
		printer_name = Imprimir.localizarImpressorasCompativeis()

		if printer_name == None:
			print u"ARGOX não localizada, cancelando procedimento"
			return False

		print "Gerando impressao em:\n{}".format(printer_name)

		resultado = False

		hPrinter = win32print.OpenPrinter(printer_name)
		try:
			hJob = win32print.StartDocPrinter (hPrinter, 1, ("ImpressaoEtiquetas", None, "RAW"))
			try:
				win32print.StartPagePrinter (hPrinter)
				win32print.WritePrinter (hPrinter, dados)
				win32print.EndPagePrinter (hPrinter)
				resultado = True
			except Exception, e:
				print str(e)
			finally:
				win32print.EndDocPrinter (hPrinter)
		except Exception, e:
			print str(e)				
		finally:
				win32print.ClosePrinter (hPrinter)

		return resultado


	def executar_ppla(self, modelo_etiqueta, imagem, **params):
		print "Executando impressao modo PPLA"
		dados = self.__carregar_modelo(modelo_etiqueta, IMG = self.__ler_imagem(imagem), **params)
		return self.__imprimir(dados)

	def executar_zpl(self, dados):
		print "Executando impressao modo ZPL"
		return self.__imprimir(dados)

