#encoding: utf-8

import requests
from impressao import Imprimir
import win32api
import win32print
import binascii
from pprint import pprint
import time
import traceback

requests.packages.urllib3.disable_warnings()

class daemon_impressao:
	def __init__(self):
		self.URL_BASE = "https://etiquetas.crisdulabs.com.br/ws/fn/pool/"
		self.conectado = False


	def __comunicar(self, url, dados = None, timeout = None):
		print "Aqui...."
		r = requests.post(self.URL_BASE + url,
			params = dados,
			timeout = timeout,
			verify=False)

		print "Resultado ok"

		print r.text

		return r.json()

	def conectar(self):
		if self.conectado:
			return True

		dados = {"computador" : win32api.GetComputerName(),
			"impressora" : Imprimir.localizarImpressorasCompativeis().replace("'","''")}
		print u"Buscando servidor de impressoes, aguarde..."

		try:
			resultado = self.__comunicar("conectar",
				dados)

			if "erro" in resultado and resultado["erro"] == 0:
				self.retorno_conexao = resultado
				self.conectado = True
				return True

			return False
		except Exception, e:
			print("Falha {} em {}".format(str(e), traceback.format_exc()))
			return False


	def verificar_pool(self):
		dados = {"ID_IMPRESSORA" : self.retorno_conexao["ID_IMPRESSORA"]}

		resultado = self.__comunicar("verificar_pool",
			dados,
			timeout = 10)

		self.resultado_pool = resultado

		if not "POOL" in resultado:
			return False

		if resultado["POOL"] == None:
			return False

		if not "BMP" in resultado and not "TAG_ZEBRA" in resultado:
			return False

		if "BMP" in resultado and not "MODELO" in resultado:
			return False

		return True

	def imprimir_ppla(self):
		bmp = binascii.unhexlify(self.resultado_pool["BMP"])
		with open("imagens/imagem.bmp", "wb+") as f:
			f.write(bmp)

		modelo = self.resultado_pool["MODELO"]
		with open("etiquetas/modelo.txt", "wb+") as f:
			f.write(modelo)

		if "IDPRODUTO" in self.resultado_pool["POOL"]:
			print "IDPRODUTO: {}".format(self.resultado_pool["POOL"]["IDPRODUTO"])

		if "QUANTIDADE" in self.resultado_pool["POOL"]:
			print "QTD: {}".format(self.resultado_pool["POOL"]["QUANTIDADE"])

		self.resultado_impressao = Imprimir().executar_ppla("modelo.txt",
			"imagem.bmp",
			**self.resultado_pool["POOL"])

		return self.resultado_impressao

	def imprimir_zpl(self):
		self.resultado_impressao = Imprimir().executar_zpl(self.resultado_pool["TAG_ZEBRA"])

		return self.resultado_impressao

	def imprimir(self):
		if not "TIPO_IMPRESSAO" in self.resultado_pool or self.resultado_pool["TIPO_IMPRESSAO"] == "PPLA":
			print "Imprimir padrao PPLA"
			return self.imprimir_ppla()
		elif self.resultado_pool["TIPO_IMPRESSAO"] == "ZPL":
			print "Imprimir padrao ZPL"
			return self.imprimir_zpl()
		else:
			print "Tipo de impressao: ", self.resultado_pool["TIPO_IMPRESSAO"], " nao reconhecido! Ignorando..."

			return False

	def informa_sucesso(self):
		resultado = self.__comunicar("informar_sucesso", {"IDPOOL" : self.resultado_pool["POOL"]["ID"],
			"resultado" : self.resultado_impressao})

		self.retorno_sucesso = resultado
		pprint(resultado)

if __name__ == "__main__":
	print u"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	print u"Servico de impressao Romance / Favorita"
	print u"Versao 2.0"
	print u"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	print u"Buscando impressoras compativeis..."
	nome_impressora = Imprimir.localizarImpressorasCompativeis()

	if nome_impressora == None:
		print u"Nenhuma impressora compativel foi localizada. Sistema cancelado."
		quit()
	else:
		print u"\tImpressora: {} localizada!".format(nome_impressora)

	daemon = daemon_impressao()

	while True:
		if daemon.conectar():
			print u"Conexao realizada com sucesso!"
			print u"Dados da conexao:"
			pprint(daemon.retorno_conexao)
			print u"Enviando solicitacao de pool. Aguardando..."
			if daemon.verificar_pool():
				print "\n****************\nYeaaaah tem pra imprimir!!!"
				daemon.imprimir()

				if daemon.resultado_impressao:
					print "\nImpressao OK"
				else:
					print "\nFalha na impressao!"

				print "\nInformando resultado para o server..."
				daemon.informa_sucesso()
				print "\nFIM"

			else:
				print "\n\nNope, sem impressao"
		else:
			print u"Servidor de impressões não localizado. Aguardando para tentar novamente..."

		time.sleep(8)

